<?php
/**
 * The PayNow Payment plugin
 *
 * @since             1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:       Payment via PayNow for WooCommerce
 * Description:       PayNow (Taiwan) Payment for WooCommerce
 * Version:           2.0.0
 * Author:            <a href="https://paynow.yangsheep.art">PayNow</a>
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wc-paynow-payment
 * Domain Path:       /languages
 * @package paynow
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'PAYNOW_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'PAYNOW_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'PAYNOW_BASENAME', plugin_basename( __FILE__ ) );
define( 'PAYNOW_PAYMENT_VERSION', '2.0.0' );

/**
 * Display warning when WooCommerce is not installed and activated.
 *
 * @return void
 */
function paynow_payment_needs_woocommerce() {

	echo '<div id="message" class="error">';
	echo '  <p>' . esc_html__( 'PayNow Payment needs WooCommerce, please intall and activate WooCommerce first!', 'wc-paynow-payment' ) . '</p>';
	echo '</div>';

}

/**
 * Run PayNow Payment plugin.
 *
 * @return void
 */
function run_paynow_payment() {

	if ( ! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		require_once ABSPATH . 'wp-admin/includes/plugin.php';
		if ( is_plugin_active( 'wc-paynow-payment/wc-paynow-payment.php' ) ) {
			deactivate_plugins( plugin_basename( __FILE__ ) );
			add_action( 'admin_notices', 'paynow_payment_needs_woocommerce' );
			return;
		}
	}

	require_once PAYNOW_PLUGIN_DIR . 'includes/class-paynow-payment.php';
	Paynow_Payment::init();
}

add_action( 'plugins_loaded', 'run_paynow_payment' );
