<?php
/**
 * Settings for barcode payment.
 *
 * @package paynow
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Settings for PayNow Barcode payment gateway
 */
return array(

	'enabled'                    => array(
		'title'   => __( 'Enable/Disable', 'wc-paynow-payment' ),
		'type'    => 'checkbox',
		'label'   => __( 'Enable', 'wc-paynow-payment' ),
		'default' => 'no',
	),
	'title'                      => array(
		'title'       => __( 'Title', 'wc-paynow-payment' ),
		'type'        => 'text',
		'description' => __( 'This controls the title which the user sees during checkout.', 'wc-paynow-payment' ),
		'default'     => __( 'PayNow Barcode Payment', 'wc-paynow-payment' ),
		'desc_tip'    => true,
	),
	'description'                => array(
		'title'       => __( 'Description', 'wc-paynow-payment' ),
		'type'        => 'textarea',
		'description' => __( 'This controls the description which the user sees during checkout.', 'wc-paynow-payment' ),
		'desc_tip'    => true,
	),
	'incomplete_payment_message' => array(
		'title'       => __( 'Incomplete Payment Message', 'wc-paynow-payment' ),
		'type'        => 'textarea',
		'description' => __( 'This controls the message displayed on thank you page when the payment is incomplated.', 'wc-paynow-payment' ),
		'desc_tip'    => true,
	),

);
