<?php
/**
 * PayNow setting class.
 *
 * @package paynow
 */

defined( 'ABSPATH' ) || exit;
/**
 * Settings class.
 */
class WC_Settings_Tab_PayNow extends WC_Settings_Page {

	/**
	 * The sections.
	 *
	 * @var $sections
	 */
	private static $sections;

	/**
	 * Setting constructor.
	 */
	public function __construct() {

		$this->id    = 'paynow';
		$this->label = __( 'PayNow', 'wc-paynow-payment' );

		self::$sections = array(
			'payment' => __( 'Payment Settings', 'wc-paynow-payment' ),
		);

		add_action( 'woocommerce_settings_' . $this->id, array( $this, 'output' ) );
		add_action( 'woocommerce_settings_save_' . $this->id, array( $this, 'save' ) );

		add_action( 'admin_init', array( $this, 'paynow_redirect_default_tab' ) );

		parent::__construct();
	}

	/**
	 * Add payment settings to sections.
	 *
	 * @param array $sections The sections.
	 * @return array
	 */
	public function paynow_payment_sections( $sections ) {

		if ( ! array_key_exists( 'payment', $sections ) ) {
			$sections['payment'] = __( 'Payment Settings', 'wc-paynow-payment' );
		}

		return $sections;
	}

	/**
	 * Get setting sections
	 *
	 * @return array
	 */
	public function get_sections() {

		$sections = array();
		if ( is_plugin_active( 'wc-paynow-payment/wc-paynow-payment.php' ) ) {
			$sections['payment'] = __( 'Payment Settings', 'wc-paynow-payment' );
		} elseif ( is_plugin_active( 'wc-paynow-shipping/wc-paynow-shipping.php' ) ) {
			$sections['shipping'] = __( 'Shipping Settings', 'wc-paynow-payment' );
		} elseif ( is_plugin_active( 'wc-paynow-einvoice/wc-paynow-einvoice.php' ) ) {
			$sections['einvoice'] = __( 'E-Invoice Settings', 'wc-paynow-payment' );
		}

		return apply_filters( 'woocommerce_get_sections_' . $this->id, $sections );
	}

	/**
	 * Get all the settings for this plugin for @see woocommerce_admin_fields() function.
	 *
	 * @return array Array of settings for @see woocommerce_admin_fields() function.
	 */
	public function get_settings( $current_section = '' ) {

		if ( 'payment' === $current_section ) {
			$settings = apply_filters(
				'paynow_payment_settings',
				array(
					array(
						'title' => __( 'General Payment Settings', 'wc-paynow-payment' ),
						'type'  => 'title',
						'id'    => 'payment_general_setting',
					),
					array(
						'title'   => __( 'Debug Log', 'wc-paynow-payment' ),
						'type'    => 'checkbox',
						'default' => 'no',
						'desc'    => sprintf( '%s <code>%s</code>', __( 'Log PayNow payment message, inside', 'wc-paynow-payment' ), wc_get_log_file_path( 'wc-paynow-payment' ) ),
						'id'      => 'paynow_payment_debug_log_enabled',
					),
					array(
						'type' => 'sectionend',
						'id'   => 'payment_general_setting',
					),
					array(
						'title' => __( 'API Settings', 'wc-paynow-payment' ),
						'type'  => 'title',
						'desc'  => __( 'Enter your PayNow API credentials', 'wc-paynow-payment' ),
						'id'    => 'paynow_payment_api_settings',
					),
					array(
						'title'   => __( 'Test Mode', 'wc-paynow-payment' ),
						'type'    => 'checkbox',
						'default' => 'yes',
						'desc'    => __( 'When enabled, you need to use the test-only data below.', 'wc-paynow-payment' ),
						'id'      => 'paynow_payment_testmode_enabled',
					),
					array(
						'title'    => __( 'WebNo', 'wc-paynow-payment' ),
						'type'     => 'text',
						'desc'     => __( 'This is the WebNo when you apply PayNow API', 'wc-paynow-payment' ),
						'desc_tip' => true,
						'id'       => 'paynow_payment_web_no',
					),
					array(
						'title'    => __( 'Transaction Password', 'wc-paynow-payment' ),
						'type'     => 'text',
						'desc'     => __( 'This is the Transaction Password when you apply PayNow API', 'wc-paynow-payment' ),
						'desc_tip' => true,
						'id'       => 'paynow_payment_trans_pwd',
					),
					array(
						'title'    => __( 'Merchant Name', 'wc-paynow-payment' ),
						'type'     => 'text',
						'desc'     => __( 'This is the Merchant Name when you apply PayNow API', 'wc-paynow-payment' ),
						'desc_tip' => true,
						'id'       => 'paynow_payment_merchant_name',
					),
					array(
						'type' => 'sectionend',
						'id'   => 'paynow_payment_api_settings',
					),
				)
			);
		}

		return apply_filters( 'woocommerce_get_settings_' . $this->id, $settings, $current_section );
	}

	/**
	 * Redirect to the default tab.
	 *
	 * @return void
	 */
	public function paynow_redirect_default_tab() {

		global $pagenow;

		if ( 'admin.php' !== $pagenow ) {
			return;
		}

		$page    = ( array_key_exists( 'page', $_GET ) ) ? wp_unslash( $_GET['page'] ) : '';
		$tab     = ( array_key_exists( 'tab', $_GET ) ) ? wp_unslash( $_GET['tab'] ) : '';
		$section = ( array_key_exists( 'section', $_GET ) ) ? wp_unslash( $_GET['section'] ) : '';

		if ( 'wc-settings' === $page && 'paynow' === $tab ) {

			if ( empty( $section ) ) {
				wp_redirect( admin_url( 'admin.php?page=wc-settings&tab=paynow&section=payment' ) );
				exit;
			}
		}

	}

	/**
	 * Output the settings fields.
	 *
	 * @return void
	 */
	public function output() {

		global $current_section;

		if ( 'payment' !== $current_section ) {
			return;
		}

		$settings = $this->get_settings( $current_section );
		WC_Admin_Settings::output_fields( $settings );
	}

	/**
	 * Display order status.
	 *
	 * @param mixed $order_status The order status.
	 *
	 * @return void
	 */
	public function output_order_section( $order_status ) {
		echo $order_status;
	}

	/**
	 * Save settings.
	 *
	 * @return void
	 */
	public function save() {

		global $current_section;

		if ( 'payment' !== $current_section ) {
			return;
		}

		$settings = $this->get_settings( $current_section );
		WC_Admin_Settings::save_fields( $settings );
	}
}
